<?php
/**
 * Title: Function
 *
 * Description: Defines theme specific functions including actions and filters.
 *
 * Please do not edit this file. This file is part of the CyberChimps Framework and all modifications
 * should be made in a child theme.
 *
 * @category CyberChimps Framework
 * @package  Framework
 * @since    1.0
 * @author   CyberChimps
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v3.0 (or later)
 * @link     http://www.cyberchimps.com/
 */

// Load text domain.
function cyberchimps_text_domain() {
	load_theme_textdomain( 'neuro', get_template_directory() . '/inc/languages' );
}
add_action( 'after_setup_theme', 'cyberchimps_text_domain' );

// Load Core
require_once( get_template_directory() . '/cyberchimps/init.php' );
require_once( get_template_directory() . '/inc/admin-about.php' );
require_once( get_template_directory() . '/inc/testimonial_template.php' );


// Set the content width based on the theme's design and stylesheet.
if( !isset( $content_width ) ) {
	$content_width = 640;
} /* pixels */

// Define site info
function cyberchimps_add_site_info() {
	?>
	<p>&copy; Company Name</p>
<?php
}

add_action( 'cyberchimps_site_info', 'cyberchimps_add_site_info' );

if( !function_exists( 'cyberchimps_comment' ) ) :

// Template for comments and pingbacks.
// Used as a callback by wp_list_comments() for displaying the comments.
	function cyberchimps_comment( $comment, $args, $depth ) {
		$GLOBALS['comment'] = $comment;
		switch( $comment->comment_type ) :
			case 'pingback' :
			case 'trackback' :
				?>
				<li class="post pingback">
				<p><?php _e( 'Pingback:', 'neuro' ); ?> <?php comment_author_link(); ?><?php edit_comment_link( __( '(Edit)', 'neuro' ), ' ' ); ?></p>
				<?php
				break;
			default :
				?>
					<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
					<article id="comment-<?php comment_ID(); ?>" class="comment hreview">
						<footer>
							<div class="comment-author reviewer vcard">
								<?php echo get_avatar( $comment, 40 ); ?>
								<?php printf( '%s <span class="says">' . __( 'says:', 'neuro' ) . '</span>', sprintf( '<cite class="fn">%s</cite>', get_comment_author_link() ) ); ?>
							</div>
							<!-- .comment-author .vcard -->
							<?php if( $comment->comment_approved == '0' ) : ?>
								<em><?php _e( 'Your comment is awaiting moderation.', 'neuro' ); ?></em>
								<br/>
							<?php endif; ?>

							<div class="comment-meta commentmetadata">
								<a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>" class="dtreviewed">
									<time pubdate datetime="<?php comment_time( 'c' ); ?>">
										<?php
										/* translators: 1: date, 2: time */
										printf( __( '%1$s at %2$s', 'neuro' ), get_comment_date(), get_comment_time() ); ?>
									</time>
								</a>
								<?php edit_comment_link( __( '(Edit)', 'neuro' ), ' ' );
								?>
							</div>
							<!-- .comment-meta .commentmetadata -->
						</footer>

						<div class="comment-content"><?php comment_text(); ?></div>

						<div class="reply">
							<?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
						</div>
						<!-- .reply -->
					</article><!-- #comment-## -->

				<?php
				break;
		endswitch;
	}
endif; // ends check for cyberchimps_comment()

// set up next and previous post links for lite themes only
function cyberchimps_next_previous_posts() {
	if( get_next_posts_link() || get_previous_posts_link() ): ?>
		<div class="more-content">
			<div class="row-fluid">
				<div class="span6 previous-post">
					<?php previous_posts_link(); ?>
				</div>
				<div class="span6 next-post">
					<?php next_posts_link(); ?>
				</div>
			</div>
		</div>
	<?php
	endif;
}

add_action( 'cyberchimps_after_content', 'cyberchimps_next_previous_posts' );

// core options customization Names and URL's
//Pro or Free
function cyberchimps_theme_check() {
	$level = 'free';

	return $level;
}

//Theme Name
function cyberchimps_options_theme_name() {
	$text = 'Neuro';

	return $text;
}

//Theme Pro Name
function cyberchimps_upgrade_bar_pro_title() {
	$text = 'Neuro Pro 3';

	return $text;
}

//Upgrade link
function cyberchimps_upgrade_bar_pro_link() {
	$url = 'http://cyberchimps.com/store/neuro-pro/';

	return $url;
}

//Doc's URL
function cyberchimps_options_documentation_url() {
	$url = 'http://cyberchimps.com/guides/c-free/';

	return $url;
}

// Support Forum URL
function cyberchimps_options_support_forum() {
	$url = 'http://cyberchimps.com/forum/free/neuro/';

	return $url;
}

add_filter( 'cyberchimps_current_theme_name', 'cyberchimps_options_theme_name', 1 );
add_filter( 'cyberchimps_upgrade_pro_title', 'cyberchimps_upgrade_bar_pro_title' );
add_filter( 'cyberchimps_upgrade_link', 'cyberchimps_upgrade_bar_pro_link' );
add_filter( 'cyberchimps_documentation', 'cyberchimps_options_documentation_url' );
add_filter( 'cyberchimps_support_forum', 'cyberchimps_options_support_forum' );

// Help Section
function cyberchimps_options_help_header() {
	$text = 'neuro';

	return $text;
}

function cyberchimps_options_help_sub_header() {
	$text = __( 'CyberChimps Professional Responsive WordPress Theme', 'neuro' );

	return $text;
}

add_filter( 'cyberchimps_help_heading', 'cyberchimps_options_help_header' );
add_filter( 'cyberchimps_help_sub_heading', 'cyberchimps_options_help_sub_header' );

// Branding images and defaults

// Banner default
function cyberchimps_banner_default() {
	$url = '/images/branding/banner.jpg';

	return $url;
}

add_filter( 'cyberchimps_banner_img', 'cyberchimps_banner_default' );

//theme specific skin options in array. Must always include option default
function cyberchimps_skin_color_options( $options ) {
	// Get path of image
	$imagepath = get_template_directory_uri() . '/inc/css/skins/images/';

	$options = array(
		'default' => $imagepath . 'default.png'
	);

	return $options;
}

add_filter( 'cyberchimps_skin_color', 'cyberchimps_skin_color_options' );

// theme specific background images
function cyberchimps_background_image( $options ) {
	$imagepath = get_template_directory_uri() . '/cyberchimps/lib/images/';
	$options   = array(
		'none'  => $imagepath . 'backgrounds/thumbs/none.png',
		'noise' => $imagepath . 'backgrounds/thumbs/noise.png',
		'blue'  => $imagepath . 'backgrounds/thumbs/blue.png',
		'dark'  => $imagepath . 'backgrounds/thumbs/dark.png',
		'space' => $imagepath . 'backgrounds/thumbs/space.png'
	);

	return $options;
}

add_filter( 'cyberchimps_background_image', 'cyberchimps_background_image' );

// theme specific typography options
function cyberchimps_typography_sizes( $sizes ) {
	$sizes = array( '8', '9', '10', '12', '14', '16', '20' );

	return $sizes;
}

function cyberchimps_typography_faces( $faces ) {
	$faces = array(
		'Arial, Helvetica, sans-serif'                     => 'Arial',
		'Arial Black, Gadget, sans-serif'                  => 'Arial Black',
		'Comic Sans MS, cursive'                           => 'Comic Sans MS',
		'Courier New, monospace'                           => 'Courier New',
		'Georgia, serif'                                   => 'Georgia',
		'Impact, Charcoal, sans-serif'                     => 'Impact',
		'Lucida Console, Monaco, monospace'                => 'Lucida Console',
		'Lucida Sans Unicode, Lucida Grande, sans-serif'   => 'Lucida Sans Unicode',
		'Palatino Linotype, Book Antiqua, Palatino, serif' => 'Palatino Linotype',
		'Tahoma, Geneva, sans-serif'                       => 'Tahoma',
		'Times New Roman, Times, serif'                    => 'Times New Roman',
		'Trebuchet MS, sans-serif'                         => 'Trebuchet MS',
		'Verdana, Geneva, sans-serif'                      => 'Verdana',
		'Symbol'                                           => 'Symbol',
		'Webdings'                                         => 'Webdings',
		'Wingdings, Zapf Dingbats'                         => 'Wingdings',
		'MS Sans Serif, Geneva, sans-serif'                => 'MS Sans Serif',
		'MS Serif, New York, serif'                        => 'MS Serif',
	);

	return $faces;
}

function cyberchimps_typography_styles( $styles ) {
	$styles = array( 'normal' => 'Normal', 'bold' => 'Bold' );

	return $styles;
}

add_filter( 'cyberchimps_typography_sizes', 'cyberchimps_typography_sizes' );
add_filter( 'cyberchimps_typography_faces', 'cyberchimps_typography_faces' );
add_filter( 'cyberchimps_typography_styles', 'cyberchimps_typography_styles' );

/**
 * Logo toggle
 *
 * @return boolean
 */
function cyberchimps_logo_toggle() {
	//turn toggle on by default
	$toggle = 1;

	return $toggle;
}

add_filter( 'cyberchimps_logo_toggle', 'cyberchimps_logo_toggle', 10 );

/**
 * Default logo in header
 *
 * @return url
 */

/**
 * Default Slider 1
 *
 * @return url
 */
function cyberchimps_slide_pro_img1() {
	$url = '/images/branding/slide1.jpg';

	return $url;
}

add_action( 'cyberchimps_slider_lite_img1', 'cyberchimps_slide_pro_img1', 10 );

/**
 * Default Slider 2
 *
 * @return url
 */
function cyberchimps_slide_pro_img2() {
	$url = '/images/branding/defaultslide.jpg';

	return $url;
}

add_action( 'cyberchimps_slider_lite_img2', 'cyberchimps_slide_pro_img2', 10 );

/**
 * Default Slider 3
 *
 * @return url
 */
function cyberchimps_slide_pro_img3() {
	$url = '/images/branding/defaultslide.jpg';

	return $url;
}

add_action( 'cyberchimps_slider_lite_img3', 'cyberchimps_slide_pro_img3', 10 );

/**
 * Add font to default fonts
 *
 * @param array $fonts
 *
 * @return array
 */
function cyberchimps_typography_faces_include( $fonts ) {
	$new_font = array(
		'"Open Sans", Helvetica, Arial, "Lucida Grande", sans-serif' => 'Open Sans'
	);

	$fonts = array_merge( $new_font, $fonts );

	return $fonts;
}

add_filter( 'cyberchimps_typography_faces', 'cyberchimps_typography_faces_include', 10, 1 );

/**
 * Sets default font settings
 *
 * @param array null $font
 *
 * @return array
 */
function cyberchimps_typography_defaults( $font ) {
	$font['face'] = '"Open Sans", Helvetica, Arial, "Lucida Grande", sans-serif';

	return $font;
}

add_filter( 'cyberchimps_typography_defaults', 'cyberchimps_typography_defaults', 10, 1 );

/**
 * [cyberchimps_typography_heading_defaults description]
 *
 * @return array
 */
function cyberchimps_typography_heading_defaults() {
	$default = array(
		'face' => '"Titillium Web", Helvetica, Arial, "Lucida Grande", sans-serif',
	);

	return $default;
}

/**
 * Overwrites the core body style functions to place background image in the #sub_body div
 *
 * @return array
 */
function cyberchimps_css_styles() {
	$body_styles      = cyberchimps_body_styles();
	$link_styles      = cyberchimps_link_styles();
	$container_styles = cyberchimps_layout_styles();
	$headings_styles  = cyberchimps_headings_styles();
	?>

	<style type="text/css" media="all">
		<?php if ( !empty( $body_styles ) ) : ?>
		body {
		<?php foreach( $body_styles as $key => $body_style ): ?> <?php echo $key; ?> : <?php echo $body_style; ?>;
		<?php endforeach; ?>
		}

		<?php if( isset( $body_styles['background-image'] ) ): ;?>
		#sub_body {
			background: <?php echo $body_styles['background-image']; ?>;
		}

		<?php endif; ?>
		<?php endif; ?>
		<?php if ( !empty( $link_styles ) ) : ?>
		<?php foreach( $link_styles as $key2 => $link_style ): ?>
		<?php echo $key2; ?>
		{
			color:
		<?php echo $link_style; ?>
		;
		}
		<?php endforeach; ?>
		<?php endif; ?>
		<?php if ( !empty( $container_styles ) ) : ?>
		.container {
		<?php foreach( $container_styles as $key3 => $container_style ): ?> <?php echo $key3; ?> : <?php echo $container_style; ?>px;
		<?php endforeach; ?>
		}

		<?php endif; ?>

		<?php if ( !empty( $headings_styles ) ) { ?>
		h1, h2, h3, h4, h5, h6 {
		<?php
		foreach( $headings_styles as $key => $headings_style ) {
			// Changed to previous code for minor font changes
			if(!empty($headings_style))
			{
			echo $key; ?> : <?php echo $headings_style; ?>;
		<?php } } ?>
		}

		<?php }

		$width = intval( cyberchimps_get_option( 'max_width' ) ) . 'px';
		if( !cyberchimps_get_option( 'responsive_design', 'checked' ) ) {
		?>
			@media screen and (max-width: <?php echo $width; ?>) {
				.container-full-width {
					width: <?php echo $width; ?>;
				}
			}
		<?php
		}


		?>
	</style>
	<?php
	return;
}

function cyberchimps_neuro_upgrade_bar(){
	$upgrade_link = apply_filters( 'cyberchimps_upgrade_link', 'http://cyberchimps.com' );
	$pro_title = apply_filters( 'cyberchimps_upgrade_pro_title', 'CyberChimps Pro' );
?>
	<br>
	<div class="upgrade-callout">
		<p><img src="<?php echo get_template_directory_uri(); ?>/cyberchimps/options/lib/images/chimp.png" alt="CyberChimps"/>
			<?php printf(
				__( 'Welcome to Neuro! Get 30%% off on %1$s using Coupon Code <span style="color:red">NEURO30</span>', 'cyberchimps_core' ),
				'<a href="' . $upgrade_link . '" target="_blank" title="' . $pro_title . '">' . $pro_title . '</a> '
			); ?>
		</p>

	<div class="social-container">
			<div class="social">
				<a href="https://twitter.com/cyberchimps" class="twitter-follow-button" data-show-count="false" data-size="small">Follow @cyberchimps</a>
				<script>!function (d, s, id) {
						var js, fjs = d.getElementsByTagName(s)[0];
						if (!d.getElementById(id)) {
							js = d.createElement(s);
							js.id = id;
							js.src = "//platform.twitter.com/widgets.js";
							fjs.parentNode.insertBefore(js, fjs);
						}
					}(document, "script", "twitter-wjs");</script>
			</div>
			<div class="social">
				<iframe
					src="//www.facebook.com/plugins/like.php?href=http%3A%2F%2Fcyberchimps.com%2F&amp;send=false&amp;layout=button_count&amp;width=200&amp;show_faces=false&amp;action=like&amp;colorscheme=light&amp;font&amp;height=21"
					scrolling="no" frameborder="0" style="border:none; overflow:hidden; width:200px; height:21px;" allowTransparency="true"></iframe>
			</div>
		</div>

	</div>
<h4 class="notice notice-info is-dismissible" style="margin-top:15px;">
<p>
<?php
	$utm_link="https://cyberchimps.com/free-download-50-stock-images-use-please/?utm_source=neuro";
 	$utm_text="Get 50 Free High-Resolution Stock Images by CyberChimps";
	printf('<a href="' . $utm_link . '" target="_blank">' . $utm_text . '</a> ');
?>
</p>
</h4>

<?php
}

add_action('admin_init','remove_upgrade_bar');
function remove_upgrade_bar(){
remove_action( 'cyberchimps_options_before_container', 'cyberchimps_upgrade_bar');
}

if( cyberchimps_theme_check() == 'free' ) {
	add_action( 'cyberchimps_options_before_container', 'cyberchimps_neuro_upgrade_bar' );
}

/**
 * [neuro_title_setup description]
 *
 * @return void.
 */
function neuro_title_setup() {

	// enabling theme support for title tag.
	add_theme_support( 'title-tag' );

	// Add support for full and wide align images.
	add_theme_support( 'align-wide' );

	// Adds support for editor color palette.
	add_theme_support(
		'editor-color-palette',
		array(
			array(
				'name'  => __( 'Gray', 'neuro' ),
				'slug'  => 'gray',
				'color' => '#777',
			),
			array(
				'name'  => __( 'Light Gray', 'neuro' ),
				'slug'  => 'light-gray',
				'color' => '#f5f5f5',
			),
			array(
				'name'  => __( 'Black', 'neuro' ),
				'slug'  => 'black',
				'color' => '#000000',
			),

			array(
				'name'  => __( 'Blue', 'neuro' ),
				'slug'  => 'blue',
				'color' => '#0286cf',
			),

			array(
				'name'  => __( 'Legacy', 'neuro' ),
				'slug'  => 'legacy',
				'color' => '#b6b6b6',
			),

			array(
				'name'  => __( 'Red', 'neuro' ),
				'slug'  => 'red',
				'color' => '#c80a00',
			),
		)
	);

}
add_action( 'after_setup_theme', 'neuro_title_setup' );

function neuro_customize_edit_links( $wp_customize ) {


   $wp_customize->selective_refresh->add_partial( 'blogname', array(
'selector' => '.site-title a'
) );

	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector' => '.top-head-description'
	) );

	$wp_customize->selective_refresh->add_partial( 'cyberchimps_options[custom_logo]', array(
		'selector' => '#logo'
	) );

	$wp_customize->selective_refresh->add_partial( 'cyberchimps_options[theme_backgrounds]', array(
		'selector' => '#social'
	) );

	$wp_customize->selective_refresh->add_partial( 'cyberchimps_options[searchbar]', array(
		'selector' => '#navigation #searchform'
	) );

	$wp_customize->selective_refresh->add_partial( 'cyberchimps_options[footer_show_toggle]', array(
		'selector' => '#footer_wrapper'
	) );

	$wp_customize->selective_refresh->add_partial( 'cyberchimps_options[footer_copyright_text]', array(
		'selector' => '#copyright'
	) );

	$wp_customize->selective_refresh->add_partial( 'nav_menu_locations[primary]', array(
		'selector' => '#navigation .nav'
	) );

	$wp_customize->selective_refresh->add_partial( 'cyberchimps_options[blog_title]', array(
		'selector' => '.page-title'
	) );

	$wp_customize->selective_refresh->add_partial( 'cyberchimps_options[footer_show_toggle]', array(
		'selector' => '#footer-widget-container'
	) );

}
add_action( 'customize_register', 'neuro_customize_edit_links' );
add_theme_support( 'customize-selective-refresh-widgets' );

add_action( 'admin_notices', 'neuro_admin_notices' );
function neuro_admin_notices()
{
	$admin_check_screen = get_admin_page_title();

	if( !class_exists('SlideDeckPlugin') )
	{
	$plugin='slidedeck/slidedeck.php';
	$slug = 'slidedeck';
	$installed_plugins = get_plugins();

	 if ( $admin_check_screen == 'Manage Themes' || $admin_check_screen == 'Theme Options Page' )
	{
		?>
		<div class="notice notice-info is-dismissible" style="margin-top:15px;">
		<p>
			<?php if( isset( $installed_plugins[$plugin] ) )
			{
			?>
				 <a href="<?php echo admin_url( 'plugins.php' ); ?>">Activate the SlideDeck Lite plugin</a>
			 <?php
			}
			else
			{
			 ?>
			 <a href="<?php echo wp_nonce_url( self_admin_url( 'update.php?action=install-plugin&plugin=' . $slug ), 'install-plugin_' . $slug ); ?>">Install the SlideDeck Lite plugin</a>
			 <?php } ?>

		</p>
		</div>
		<?php
	}
	}

	if( !class_exists('WPForms') )
	{
	$plugin = 'wpforms-lite/wpforms.php';
	$slug = 'wpforms-lite';
	$installed_plugins = get_plugins();
	 if ( $admin_check_screen == 'Manage Themes' || $admin_check_screen == 'Theme Options Page' )
	{
		?>
		<div class="notice notice-info is-dismissible" style="margin-top:15px;">
		<p>
			<?php if( isset( $installed_plugins[$plugin] ) )
			{
			?>
				 <a href="<?php echo admin_url( 'plugins.php' ); ?>">Activate the WPForms Lite plugin</a>
			 <?php
			}
			else
			{
			 ?>
	 		 <a href="<?php echo wp_nonce_url( self_admin_url( 'update.php?action=install-plugin&plugin=' . $slug ), 'install-plugin_' . $slug ); ?>">Install the WP Forms Lite plugin</a>
			 <?php } ?>
		</p>
		</div>
		<?php
	}
	}

	if ( $admin_check_screen == 'Manage Themes' || $admin_check_screen == 'Theme Options Page' )
	{
	?>
		<div class="notice notice-success is-dismissible">
				<b><p>Liked this theme? <a href="https://wordpress.org/support/theme/neuro/reviews/#new-post" target="_blank">Leave us</a> a ***** rating. Thank you! </p></b>
		</div>
		<?php
	}

}


/**
 * [neuro_enqueue description]
 *
 * @return void
 */
function neuro_enqueue() {
	$directory_uri = get_template_directory_uri();
	wp_enqueue_script( 'jquery-flexslider', $directory_uri . '/inc/js/jquery.flexslider.js', 'jquery', '1.0', true );
}
add_action( 'wp_enqueue_scripts', 'neuro_enqueue' );


/**
 *  Enqueue block styles  in editor
 */
function neuro_block_styles() {

	wp_enqueue_style( 'neuro-google-font', 'https://fonts.googleapis.com/css?family=Open+Sans|Titillium+Web', array(), '1.0' );

	$typography_options   = cyberchimps_get_option( 'typography_options' );
	$font_family_headings = cyberchimps_get_option( 'font_family_headings' );

	$font_family                = $typography_options['face'] ? $typography_options['face'] : '"Open Sans", Helvetica, Arial, "Lucida Grande", sans-serif';
	$font_size                  = $typography_options['size'] ? $typography_options['size'] : '14px';
	$font_weight                = $typography_options['style'] ? $typography_options['style'] : 'Normal';
	$color                      = cyberchimps_get_option( 'text_colorpicker' ) ? cyberchimps_get_option( 'text_colorpicker' ) : '#444';
	$link_colorpicker           = cyberchimps_get_option( 'link_colorpicker' ) ? cyberchimps_get_option( 'link_colorpicker' ) : '#666666';
	$link_hover_colorpicker     = cyberchimps_get_option( 'link_hover_colorpicker' ) ? cyberchimps_get_option( 'link_hover_colorpicker' ) : '#005580';
	$neuro_font_family_headings = $font_family_headings['face'] ? $font_family_headings['face'] : '"Titillium Web", Helvetica, Arial, "Lucida Grande", sans-serif';

	?>
	<style>

	.editor-writing-flow,
	.editor-styles-wrapper{
		font-family: <?php echo $font_family; ?>;
		font-size: <?php echo esc_html( $font_size, 'neuro' ); ?>;
		font-weight: <?php echo esc_html( $font_weight, 'neuro' ); ?>;
		color: <?php echo esc_html( $color, 'neuro' ); ?>;
		line-height: 1.5;
	}
	.wp-block-freeform.block-library-rich-text__tinymce h1,
	.wp-block-freeform.block-library-rich-text__tinymce h2,
	.wp-block-freeform.block-library-rich-text__tinymce h3,
	.wp-block-freeform.block-library-rich-text__tinymce h4,
	.wp-block-freeform.block-library-rich-text__tinymce h5,
	.wp-block-freeform.block-library-rich-text__tinymce h6,
	.wp-block-heading h1.editor-rich-text__tinymce,
	.wp-block-heading h2.editor-rich-text__tinymce,
	.wp-block-heading h3.editor-rich-text__tinymce,
	.wp-block-heading h4.editor-rich-text__tinymce,
	.wp-block-heading h5.editor-rich-text__tinymce,
	.wp-block-heading h6.editor-rich-text__tinymce {
		font-family: <?php echo $neuro_font_family_headings; ?>;
		font-weight: 700;
		margin-bottom: 15px;
	}
	.editor-post-title__block .editor-post-title__input{
		font-family: <?php echo $neuro_font_family_headings; ?> !important;
	}

	.wp-block-freeform.block-library-rich-text__tinymce a,
	.editor-writing-flow a{
		color: <?php echo esc_html( $link_colorpicker, 'neuro' ); ?>;
		text-decoration: none;
	}

	.wp-block-freeform.block-library-rich-text__tinymce a:hover,
	.wp-block-freeform.block-library-rich-text__tinymce a:focus,
	.editor-writing-flow a:hover,
	.editor-writing-flow a:focus{
		color:  <?php echo esc_html( $link_hover_colorpicker, 'neuro' ); ?>;
	}

	</style>
	<?php
	wp_enqueue_style( 'neuro-gutenberg-blocks', get_stylesheet_directory_uri() . '/inc/css/gutenberg-blocks.css', array(), '1.0' );

}
add_action( 'enqueue_block_editor_assets', 'neuro_block_styles' );

/**
 * [neuro_set_defaults description].
 */
function neuro_set_defaults() {
	remove_action( 'testimonial', array( CyberChimpsTestimonial::instance(), 'render_display' ) );
	add_action( 'testimonial', 'neuro_testimonial_render_display' );
}
add_action( 'init', 'neuro_set_defaults' );
